gsap.registerPlugin(ScrollTrigger, ScrollToPlugin);
(function preloadTransform() {
  window.addEventListener("load", function (event) {
    // document.body.style.overflow = "visible";
    document.body.classList.add('loaded');

  });
})();

(function mapCard() {
  const targets = document.querySelectorAll(".js-mapPlaces");

  targets.forEach((target) => {
    const cards = target.querySelectorAll("[data-map-card]");
    const buttons = target.querySelectorAll(`[data-map-place]`);

    cards.forEach((el) => {
      const attrVal = el.getAttribute("data-map-card");
      const button = target.querySelector(`[data-map-place="${attrVal}"]`);

      el.addEventListener("click", (e) => {
        cards.forEach((el) => el.classList.remove("isCardActive"));
        buttons.forEach((el) => el.classList.remove("isActive"));

        if (!el.classList.contains("isCardActive")) {
          button.classList.toggle("isActive");
          el.classList.add("isCardActive");
        }
      });
    });
  });
})();

(function gsapMatchMedia() {
  ScrollTrigger.matchMedia({
    all: function () {
      let bodyOverlay = document.createElement("div");
      bodyOverlay.classList.add("body-overlay");
      document.body.append(bodyOverlay);

      const tlMenu = gsap.timeline({ paused: true });

      tlMenu
        .from(".menu__dropdown", { yPercent: -200, opacity: 0 })
        .to(".menu__dropdown", { yPercent: 0, opacity: 1 })
        .to(".menu__burger", { yPercent: 0, opacity: 1 })
        .to(".body-overlay", { visibility: "visible", autoAlpha: 1 }, 0)
        .to(".menu__burger-line_mid", { width: 0 }, 0)
        .to(".menu__burger-line_top", { y: 8 }, 0)
        .to(".menu__burger-line_bot", { y: -9.5 }, 0)
        .to(".menu__burger-line_top", { rotate: 45 }, 0.5)
        .to(".menu__burger-line_bot", { rotate: -45 }, 0.5)
        .from(".menu__item", { autoAlpha: 0, stagger: 0.05 }, 0.6)

      const btnToggler = document.querySelector(".btn-toggler");
      btnToggler.addEventListener("click", toggleMenu);
      document
        .querySelector(".body-overlay")
        .addEventListener("click", toggleMenu);
      function toggleMenu() {
        tlMenu.reversed()
          ? tlMenu.timeScale(1).play()
          : tlMenu.timeScale(2).reverse();
        btnToggler.classList.toggle("open");
      }
      tlMenu.reverse();
      function getSamePageAnchor(link) {
        if (
          link.protocol !== window.location.protocol ||
          link.host !== window.location.host ||
          link.pathname !== window.location.pathname ||
          link.search !== window.location.search
        ) {
          return false;
        }

        return link.hash;
      }

      function scrollToHash(hash, e) {
        const elem = hash ? document.querySelector(hash) : false;
        if (elem) {
          if (e) e.preventDefault();
          gsap.to(window, { scrollTo: elem });
        }
      }

      document.querySelectorAll("a[href]").forEach((a) => {
        a.addEventListener("click", (e) => {
          scrollToHash(getSamePageAnchor(a), e);
        });
      });
const sections = document.querySelectorAll('section');

const sidebarItems = document.querySelectorAll('.sidebar__item');
const offset = 70; 

function setActiveItem() {
  const scrollPosition = window.pageYOffset;

  sections.forEach((section, index) => {
    const sectionTop = section.offsetTop - offset; 
    const sectionHeight = section.offsetHeight;

    if (scrollPosition >= sectionTop && scrollPosition < sectionTop + sectionHeight) {
      sidebarItems.forEach((item) => {
        item.classList.remove('active');
      });
      sidebarItems[index].classList.add('active');
    }
  });
}

window.addEventListener('scroll', setActiveItem);

      document.querySelectorAll(".menu__mobile .main-nav-link").forEach((a) => {
        a.addEventListener("click", (e) => {
          toggleMenu();
        });
      });

      scrollToHash(window.location.hash);

      

    },
    // 2500 - 993
    "(max-width: 2500px) and (min-width: 993px)": function () {
      const tlProjectsTop = gsap.utils.toArray(".gsap-bottom");
      tlProjectsTop.forEach((elem) => {
        gsap.from(elem, {
          yPercent: 50,
          duration: 1,
          opacity: 0,
          scrollTrigger: {
            trigger: elem,
          },
        });
      });

      const tlProjectsLeft = gsap.utils.toArray(".gsap-left");
      tlProjectsLeft.forEach((elem) => {
        gsap.from(elem, {
          xPercent: -50,
          duration: 1,
          scrollTrigger: {
            trigger: elem,
          },
        });
      });
      const tlProjectsRight = gsap.utils.toArray(".gsap-right");
      tlProjectsRight.forEach((elem) => {
        gsap.from(elem, {
          xPercent: 50,
          duration: 1,
          opacity: 0,
          scrollTrigger: {
            trigger: elem,
          },
        });
      });

      const tlProjectsScale = gsap.utils.toArray(".gsap-scale");
      tlProjectsScale.forEach((elem) => {
        gsap.from(elem, {
          scale: 0.5,
          duration: 1,
          opacity: 0,
          scrollTrigger: {
            trigger: elem,
          },
        });
      });
    },
    // 992 - 769
    "(max-width: 992px) and (min-width: 320px)": function () {
      const tlProjectsTop = gsap.utils.toArray(".gsap-bottom");
      tlProjectsTop.forEach((elem) => {
        gsap.from(elem, {
          yPercent: 50,
          duration: 1,
          opacity: 0,
          scrollTrigger: {
            trigger: elem,
          },
        });
      });

      const tlProjectsLeft = gsap.utils.toArray(".gsap-left");
      tlProjectsLeft.forEach((elem) => {
        gsap.from(elem, {
          yPercent: 50,
          duration: 1,
          opacity: 0,
          scrollTrigger: {
            trigger: elem,
          },
        });
      });
      const tlProjectsRight = gsap.utils.toArray(".gsap-right");
      tlProjectsRight.forEach((elem) => {
        gsap.from(elem, {
          yPercent: 50,
          duration: 1,
          opacity: 0,
          scrollTrigger: {
            trigger: elem,
          },
        });
      });

      const tlProjectsScale = gsap.utils.toArray(".gsap-scale");
      tlProjectsScale.forEach((elem) => {
        gsap.from(elem, {
          scale: 0.5,
          duration: 1,
          opacity: 0,
          scrollTrigger: {
            trigger: elem,
          },
        });
      });
    },
    // 768 - 577
    // "(max-width: 768px) and (min-width: 577px)": function () {},
    // 576 - 320
    // "(max-width: 576px) and (min-width: 320px)": function () {},
  });
})();
