// (function floorSwipe() {
//     document.querySelectorAll(".floorplans__swiper.swiper").forEach(function (el, index) {
//       const swiper = new Swiper(el, {
//         grabCursor: true,
//         centeredSlides: true,
//         slidesPerView: 1,
//         spaceBetween: 30,
//         effect: "fade",
//         pagination: {
//           el: ".floorplans__swiper-pagination.swiper-pagination",
//           clickable: true,
//         },
//       });
//     });
//   })();
// (function floorSwipe() {
//   var tabPanes = document.querySelectorAll(".floorplans__swiper-body");

//   tabPanes.forEach(function (tabPane) {
//     var sliderElements = tabPane.querySelectorAll(".floor-mobile__swiper-main");
//     var thumbElements = tabPane.querySelectorAll(
//       ".floor-mobile__swiper-thumb"
//     );

//     sliderElements.forEach(function (slider) {
//       var swiperThumbMob = new Swiper(slider.nextElementSibling, {
//         slidesPerView: "auto",
//         freeMode: true,
//         spaceBetween: 10,
//         watchSlidesProgress: true,
//         allowTouchMove: false,
//         effect: "fade",
//       });

//       var swiperBig = new Swiper(slider, {
//         spaceBetween: 10,
//         slidesPerView: "auto",
//         pagination: {
//           el: ".floorplans__swiper-pagination.swiper-pagination",
//           clickable: true,
//         },
//         thumbs: {
//           swiper: swiperThumbMob,
//         },
//       });
//     });
//   });
// })();

(function floorSwipe() {
  var tabPanes = document.querySelectorAll(".floorplans__swiper-body");

  tabPanes.forEach(function (tabPane) {
    var sliderElements = tabPane.querySelectorAll(".floor-mobile__swiper-main");
    var thumbElements = tabPane.querySelectorAll(".floor-mobile__swiper-thumb");

    sliderElements.forEach(function (slider) {
      var swiperBig = new Swiper(slider, {
        spaceBetween: 10,
        slidesPerView: "auto",
        pagination: {
          el: ".floorplans__swiper-pagination.swiper-pagination",
          clickable: true,
        },
      });

      thumbElements.forEach(function (thumbSlider) {
        var swiperThumbMob = new Swiper(thumbSlider, {
          slidesPerView: "auto",
          freeMode: true,
          spaceBetween: 10,
          watchSlidesProgress: true,
          allowTouchMove: false,
          effect: "fade",

        });

        swiperBig.controller.control = swiperThumbMob;
        swiperThumbMob.controller.control = swiperBig;
      });
    });
  });

  // Добавляем обработчик события на переключение табов
  var tabLinks = document.querySelectorAll(".floorplans__nav-link");
  tabLinks.forEach(function (tabLink) {
    tabLink.addEventListener("click", function () {
      // Задержка для переинициализации swiperThumbMob после переключения табов
      setTimeout(function () {
        tabPanes.forEach(function (tabPane) {
          var thumbElements = tabPane.querySelectorAll(".floor-mobile__swiper-thumb");
          thumbElements.forEach(function (thumbSlider) {
            var swiperThumbMob = new Swiper(thumbSlider, {
              slidesPerView: "auto",
              freeMode: true,
              spaceBetween: 10,
              watchSlidesProgress: true,
              allowTouchMove: false,
              effect: "fade",
            });
          });
        });
      }); // Задержка в миллисекундах
    });
  });
})();

// (function floorSwipe() {
//   let sliderMain = document.querySelectorAll(".floor-mobile__swiper-thumb");
//   let sliderNav = document.querySelectorAll(".floor-mobile__swiper-main");

//   sliderMain.forEach(function (element, i) {
//     new Swiper(element, {
//         spaceBetween: 10,
//         slidesPerView: "auto",
//     });
//   });

//   sliderNav.forEach(function (element, i) {
//     var self = sliderNav;
//     new Swiper(element, {
//       slidesPerView: "auto",
//       freeMode: true,
//       spaceBetween: 10,
//       watchSlidesProgress: true,
//       allowTouchMove: false,
//       effect: "fade",
//       thumbs: {
//         swiper: self,
//       },
//       pagination: {
//         el: ".floorplans__swiper-pagination.swiper-pagination",
//         clickable: true,
//       },
//     });
//   });
// })();

(function gallerySwipe() {
  document
    .querySelectorAll(".gallery__swiper.swiper")
    .forEach(function (el, index) {
      const swiper = new Swiper(el, {
        slidesPerView: 1,
        spaceBetween: 30,
        // autoHeight: true,
        pagination: {
          el: ".gallery__swiper-pagination.swiper-pagination",
          clickable: true,
        },
      });
    });
})();

(function locationSwipe() {
  var swiperMap = new Swiper(".location__swiper-map", {
    spaceBetween: 10,
    effect: "fade",
    allowTouchMove: false,
  });
  var swiperInfo = new Swiper(".location__swiper-info", {
    spaceBetween: 10,
    effect: "fade",
    allowTouchMove: false,
    thumbs: {
      swiper: swiperMap,
    },
  });
  var swiperImg = new Swiper(".location__swiper-img", {
    spaceBetween: 10,
    effect: "coverflow",
    grabCursor: true,
    centeredSlides: true,
    slidesPerView: "auto",
    coverflowEffect: {
      rotate: 0,
      stretch: 0,
      depth: 1000,
      modifier: 2,
      slideShadows: true,
    },
    pagination: {
      el: ".location__swiper-pagination.swiper-pagination",
      clickable: true,
    },
    grabCursor: true,
    thumbs: {
      swiper: swiperInfo,
    },
  });
})();
