(function floorSwipe() {
  var tabPanes = document.querySelectorAll(".floorplans__swiper-body");
  var tabLinks = document.querySelectorAll(".floorplans__nav-link");

  tabPanes.forEach(function (tabPane) {
    var sliderElements = tabPane.querySelectorAll(".floor-mobile__swiper-main");
    var thumbElements = tabPane.querySelectorAll(".floor-mobile__swiper-thumb");

    sliderElements.forEach(function (slider) {
      var swiperBig = new Swiper(slider, {
        spaceBetween: 10,
        slidesPerView: "auto",
        pagination: {
          el: ".floorplans__swiper-pagination.swiper-pagination",
          clickable: true,
        },
      });

      thumbElements.forEach(function (thumbSlider) {
        var swiperThumbMob = new Swiper(thumbSlider, {
          slidesPerView: "auto",
          freeMode: true,
          spaceBetween: 10,
          watchSlidesProgress: true,
          allowTouchMove: false,
          effect: "fade",
        });

        swiperBig.controller.control = swiperThumbMob;
        swiperThumbMob.controller.control = swiperBig;
		  
		  
		  // При переключении между табами всегда начинаем с первого слайда, only mobile
		tabLinks.forEach(function (tabLink) {
		  tabLink.addEventListener("click", () => {
			swiperBig.slideTo(0);
			swiperThumbMob.slideTo(0);
		   });
		 })

		  
		  
      });
    });
  });

  // Добавляем обработчик события на переключение табов

  tabLinks.forEach(function (tabLink) {
    tabLink.addEventListener("click", function () {
      // Задержка для переинициализации swiperThumbMob после переключения табов
      setTimeout(function () {
        tabPanes.forEach(function (tabPane) {
          var thumbElements = tabPane.querySelectorAll(
            ".floor-mobile__swiper-thumb"
          );
          thumbElements.forEach(function (thumbSlider) {
            var swiperThumbMob = new Swiper(thumbSlider, {
              slidesPerView: "auto",
              freeMode: true,
              spaceBetween: 10,
              watchSlidesProgress: true,
              allowTouchMove: false,
              effect: "fade",
            });
          });
        });
      }); // Задержка в миллисекундах
    });
  });
})();
