const closeButtons = document.querySelectorAll('.popup-close');
const buttons = document.querySelectorAll('[data-popup]');
const popups = document.querySelectorAll('.popup');

function close() {
    popups.forEach(popup => {
        popup.classList.remove('active');
        document.body.style.overflowY = 'auto';
    })
}

buttons.forEach(button => {
    button.addEventListener('click', () => {
        if(button.classList.contains('take-content')){
            const price = button.parentElement.querySelector('.price').innerHTML;
            const image = button.parentElement.parentElement.querySelector('.floor__item-img img').getAttribute('src');
        }
        const target = button.getAttribute('data-popup');
        const popup = document.querySelector(target);
        popup.classList.add('active');
        document.body.style.overflowY = 'hidden';
    }); 
});

popups.forEach(popup => {
    if(popup.querySelector('.popup__bg')){
        const bg = popup.querySelector('.popup__bg');
        if(bg.classList.contains('multiple')){
            function loop(){
                const img = popup.querySelector('.popup__bg-img.active');
                const firstImg = popup.querySelector('.popup__bg-img.first');
                setTimeout(() => {
                    img.classList.remove('active');
                    if(!img.classList.contains('last')){
                        img.nextElementSibling.classList.add('active');
                    }else{
                        firstImg.classList.add('active');
                    }
                    loop()
                }, 2000);
            }
            loop();
        }
    }
	
	popup.addEventListener('click', (event) => {
		if (event.currentTarget === event.target) {
			close();
		}
    })
	
	
})

closeButtons.forEach(closeButton => {
    closeButton.addEventListener('click', () => {
        close()
    })
})

// time popup

document.addEventListener("DOMContentLoaded", function () {
const timePopup = document.querySelector('#time-popup');
const allPopups = document.querySelectorAll('.popup');
const allBtnsPop = document.querySelectorAll('button');

	const itemTl = gsap.timeline({
            scrollTrigger: {
                trigger: '.prague_list',
                start: 'center+=300 center',
                end: 'center+=50 center',
				once: true,
                onEnter: () => {
                    document.querySelector('#time-popup').classList.add('active');
                },
            },
        });
	
	
const timerIdPop = setTimeout(function(){ 
  timePopup.classList.add('active')
  document.body.style.overflowY = 'hidden';
},5000);
	
allBtnsPop.forEach((item)=>{
	item.addEventListener('click', ()=> {
		clearTimeout(timerIdPop);
	})
})
	
	
});

// popup first sec

const wpPopupBtn = document.querySelector('.wp-popup-btn');
const wpPopup = document.querySelector('.wp-popup');
const wpPopupExit = document.querySelector('.wp-popup__exit');


wpPopupBtn.addEventListener('click', ()=> {
  wpPopup.classList.add('active');
	document.body.classList.add('no-scroll');
});

wpPopupExit.addEventListener("click", () => {
  document.body.classList.remove('no-scroll');
  wpPopup.classList.remove('active');
  document.body.classList.remove('hide-wp');
});

wpPopup.addEventListener("click", (e) => {
  if (e.target.closest(".wp-popup__wrapper")) {
    return;
  }
  document.body.classList.remove('no-scroll');
  wpPopup.classList.remove('active');
  document.body.classList.remove('hide-wp');
});

